/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.potions;

import com.hollingsworth.arsnouveau.api.event.BounceTimedEvent;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;

@EventBusSubscriber(modid="ars_nouveau")
public class BounceEffect
extends MobEffect {
    public BounceEffect() {
        super(MobEffectCategory.BENEFICIAL, 2039587);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || !entity.hasEffect(ModPotions.BOUNCE_EFFECT)) {
            return;
        }
        boolean isPlayer = entity instanceof Player;
        boolean isClient = entity.level.isClientSide;
        if (isClient && !isPlayer) {
            return;
        }
        if (event.getDistance() > 2.0f) {
            if (entity.isCrouching()) {
                event.setDamageMultiplier(0.0f);
            } else {
                event.setDamageMultiplier(0.0f);
                entity.fallDistance = 0.0f;
                if (!isPlayer || isClient) {
                    double f = 0.95 - 0.1 * (double)entity.getEffect(ModPotions.BOUNCE_EFFECT).getAmplifier();
                    entity.setDeltaMovement(entity.getDeltaMovement().x / f, entity.getDeltaMovement().y * -0.9, entity.getDeltaMovement().z / f);
                    entity.hurtMarked = true;
                    entity.setOnGround(false);
                }
                if (isClient) {
                    EventQueue.getClientQueue().addEvent(new BounceTimedEvent(entity, entity.getDeltaMovement().y));
                } else {
                    EventQueue.getServerInstance().addEvent(new BounceTimedEvent(entity, entity.getDeltaMovement().y));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onFlyWallDamage(LivingDamageEvent.Pre event) {
        DamageContainer container = event.getContainer();
        DamageSource source = container.getSource();
        LivingEntity entity = event.getEntity();
        if (entity == null || !entity.hasEffect(ModPotions.BOUNCE_EFFECT)) {
            return;
        }
        boolean isPlayer = entity instanceof Player;
        if (!isPlayer) {
            return;
        }
        if (source.is(DamageTypes.FLY_INTO_WALL)) {
            container.setNewDamage(0.0f);
            Vec3 lookAngle = entity.getLookAngle();
            entity.setDeltaMovement(lookAngle.scale(-2.0));
            entity.hurtMarked = true;
        }
    }
}

